<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* MalwareStateForWindowsDevice File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Microsoft\Graph\Model;

/**
* MalwareStateForWindowsDevice class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class MalwareStateForWindowsDevice extends Entity
{
    /**
    * Gets the detectionCount
    * Indicates the number of times the malware is detected
    *
    * @return int|null The detectionCount
    */
    public function getDetectionCount()
    {
        if (array_key_exists("detectionCount", $this->_propDict)) {
            return $this->_propDict["detectionCount"];
        } else {
            return null;
        }
    }

    /**
    * Sets the detectionCount
    * Indicates the number of times the malware is detected
    *
    * @param int $val The detectionCount
    *
    * @return MalwareStateForWindowsDevice
    */
    public function setDetectionCount($val)
    {
        $this->_propDict["detectionCount"] = intval($val);
        return $this;
    }

    /**
    * Gets the deviceName
    * Indicates the name of the device being evaluated for malware state
    *
    * @return string|null The deviceName
    */
    public function getDeviceName()
    {
        if (array_key_exists("deviceName", $this->_propDict)) {
            return $this->_propDict["deviceName"];
        } else {
            return null;
        }
    }

    /**
    * Sets the deviceName
    * Indicates the name of the device being evaluated for malware state
    *
    * @param string $val The deviceName
    *
    * @return MalwareStateForWindowsDevice
    */
    public function setDeviceName($val)
    {
        $this->_propDict["deviceName"] = $val;
        return $this;
    }

    /**
    * Gets the executionState
    * Indicates execution status of the malware. Possible values are: unknown, blocked, allowed, running, notRunning. Defaults to unknown. Possible values are: unknown, blocked, allowed, running, notRunning.
    *
    * @return WindowsMalwareExecutionState|null The executionState
    */
    public function getExecutionState()
    {
        if (array_key_exists("executionState", $this->_propDict)) {
            if (is_a($this->_propDict["executionState"], "\Microsoft\Graph\Model\WindowsMalwareExecutionState") || is_null($this->_propDict["executionState"])) {
                return $this->_propDict["executionState"];
            } else {
                $this->_propDict["executionState"] = new WindowsMalwareExecutionState($this->_propDict["executionState"]);
                return $this->_propDict["executionState"];
            }
        }
        return null;
    }

    /**
    * Sets the executionState
    * Indicates execution status of the malware. Possible values are: unknown, blocked, allowed, running, notRunning. Defaults to unknown. Possible values are: unknown, blocked, allowed, running, notRunning.
    *
    * @param WindowsMalwareExecutionState $val The executionState
    *
    * @return MalwareStateForWindowsDevice
    */
    public function setExecutionState($val)
    {
        $this->_propDict["executionState"] = $val;
        return $this;
    }

    /**
    * Gets the initialDetectionDateTime
    * Initial detection datetime of the malware
    *
    * @return \DateTime|null The initialDetectionDateTime
    */
    public function getInitialDetectionDateTime()
    {
        if (array_key_exists("initialDetectionDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["initialDetectionDateTime"], "\DateTime") || is_null($this->_propDict["initialDetectionDateTime"])) {
                return $this->_propDict["initialDetectionDateTime"];
            } else {
                $this->_propDict["initialDetectionDateTime"] = new \DateTime($this->_propDict["initialDetectionDateTime"]);
                return $this->_propDict["initialDetectionDateTime"];
            }
        }
        return null;
    }

    /**
    * Sets the initialDetectionDateTime
    * Initial detection datetime of the malware
    *
    * @param \DateTime $val The initialDetectionDateTime
    *
    * @return MalwareStateForWindowsDevice
    */
    public function setInitialDetectionDateTime($val)
    {
        $this->_propDict["initialDetectionDateTime"] = $val;
        return $this;
    }

    /**
    * Gets the lastStateChangeDateTime
    * The last time this particular threat was changed
    *
    * @return \DateTime|null The lastStateChangeDateTime
    */
    public function getLastStateChangeDateTime()
    {
        if (array_key_exists("lastStateChangeDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["lastStateChangeDateTime"], "\DateTime") || is_null($this->_propDict["lastStateChangeDateTime"])) {
                return $this->_propDict["lastStateChangeDateTime"];
            } else {
                $this->_propDict["lastStateChangeDateTime"] = new \DateTime($this->_propDict["lastStateChangeDateTime"]);
                return $this->_propDict["lastStateChangeDateTime"];
            }
        }
        return null;
    }

    /**
    * Sets the lastStateChangeDateTime
    * The last time this particular threat was changed
    *
    * @param \DateTime $val The lastStateChangeDateTime
    *
    * @return MalwareStateForWindowsDevice
    */
    public function setLastStateChangeDateTime($val)
    {
        $this->_propDict["lastStateChangeDateTime"] = $val;
        return $this;
    }

    /**
    * Gets the threatState
    * Indicates threat status of the malware. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared. defaults to noStatusCleared. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared.
    *
    * @return WindowsMalwareThreatState|null The threatState
    */
    public function getThreatState()
    {
        if (array_key_exists("threatState", $this->_propDict)) {
            if (is_a($this->_propDict["threatState"], "\Microsoft\Graph\Model\WindowsMalwareThreatState") || is_null($this->_propDict["threatState"])) {
                return $this->_propDict["threatState"];
            } else {
                $this->_propDict["threatState"] = new WindowsMalwareThreatState($this->_propDict["threatState"]);
                return $this->_propDict["threatState"];
            }
        }
        return null;
    }

    /**
    * Sets the threatState
    * Indicates threat status of the malware. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared. defaults to noStatusCleared. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared.
    *
    * @param WindowsMalwareThreatState $val The threatState
    *
    * @return MalwareStateForWindowsDevice
    */
    public function setThreatState($val)
    {
        $this->_propDict["threatState"] = $val;
        return $this;
    }

}
